local matrix={}
local font
local windowWidth,windowHeight
local spacing=10
local columns
local streams={}
local chars={}
function matrix.load()
local fontSize=36
font=love.graphics.newFont("matrixcode.ttf",fontSize)
windowWidth,windowHeight=love.graphics.getDimensions()
local fontWidth=font:getWidth("a")
local totalWidthPerStream=fontWidth+spacing
columns=math.floor(windowWidth/totalWidthPerStream)
streams={}
for i=1,columns do streams[i]={x=(i-1)*totalWidthPerStream,y=math.random(-windowHeight,0),speed=math.random(50,300),characters={},maxLength=math.random(5,20),timer=0} end
chars={}
local alpha="abcdefghijklmnopqrstuvwxyz0123456789"
for c in alpha:gmatch(".") do table.insert(chars,c) end
end
function matrix.update(dt)
for _,stream in ipairs(streams) do
stream.timer=stream.timer+dt
local delay=font:getHeight()/stream.speed
if stream.timer>=delay then
stream.y=stream.y+font:getHeight()
stream.timer=stream.timer-delay
if stream.y>windowHeight+(stream.maxLength*font:getHeight()) then
stream.y=math.random(-windowHeight,0)
stream.speed=math.random(50,300)
stream.characters={}
end
if #stream.characters<stream.maxLength then local char=chars[math.random(#chars)] if math.random()<0.05 then table.insert(stream.characters,{char=char,color={1,1,1,1},fadeTimer=0}) else table.insert(stream.characters,{char=char,color={0,1,0,1},fadeTimer=0}) end end
end
for _,charData in ipairs(stream.characters) do if charData.fadeTimer<5 then charData.fadeTimer=charData.fadeTimer+dt if charData.fadeTimer>5 then charData.fadeTimer=25
end end end end end
local function drawBoldText(text,x,y,color)
local offsets={{x=0,y=0},{x=1,y=0},{x=0,y=1},{x=1,y=1}}
for _,offset in ipairs(offsets) do love.graphics.setColor(color[1],color[2],color[3],color[4]) love.graphics.print(text,x+offset.x,y+offset.y) end
end
local function drawGlowText(text,x,y,color)
local glowOffsets={{-1,-1},{0,-1},{1,-1},{-1,0},{0,0},{1,0},{-1,1},{0,1},{1,1}}
local glowColor={color[1],color[2],color[3],color[4]*0.2}
for _,offset in ipairs(glowOffsets) do love.graphics.setColor(glowColor) love.graphics.print(text,x+offset[1],y+offset[2]) end
end
function matrix.draw()
local prevFont=love.graphics.getFont()
love.graphics.setFont(font)
for _,stream in ipairs(streams) do
for i,charData in ipairs(stream.characters) do
local charX=stream.x
local charY=stream.y-((i-1)*font:getHeight())
local fadeOpacity=math.min(charData.fadeTimer/5,1)*0.08
local color={charData.color[1],charData.color[2],charData.color[3],fadeOpacity}
drawGlowText(charData.char,charX,charY,color)
drawBoldText(charData.char,charX,charY,color)
end end
love.graphics.setColor(1,1,1,1)
love.graphics.setFont(prevFont)
end
function matrix.resize(w,h)
windowWidth,windowHeight=w,h
local fontWidth=font:getWidth("a")
local totalWidthPerStream=fontWidth+spacing
columns=math.floor(windowWidth/totalWidthPerStream)
while #streams<columns do table.insert(streams,{x=(#streams)*totalWidthPerStream,y=math.random(-windowHeight,0),speed=math.random(50,300),characters={},maxLength=math.random(5,20),timer=0}) end
while #streams>columns do table.remove(streams) end
end
return matrix
